using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;

namespace Zlatnici_3
{
    internal class Program
    {
        struct Veza
        {
            public int x, y;
        }

        static int[,] Map(int n, Veza[] veze)
        {
            int[,] map = new int[n, n];
            for(int i = 0; i < n; i++)
            {
                for(int j = 0; j < n; j++)
                {
                    if (i == j) map[i, j] = 0;
                    else if (map[i, j] == 0)
                    {
                        map[i, j] = Konekcija(veze, i, j);
                        map[j, i] = map[i, j];
                    }
                }
            }
            return map;
        }

        static int Konekcija(Veza[] veze, int x, int y)
        {
            for (int i = 0; i < veze.Count(); i++)
            {
                Veza veza = veze[i];
                if ((veza.x == x && veza.y == y) || (veza.x == y && veza.y == x)) return 1;
            }
            List<int> mogucnosti = new List<int>();
            for (int i = 0; i < veze.Count(); i++)
            {
                Veza veza = veze[i];
                if (veza.x == x || veza.x == y || veza.y == x || veza.y == y)
                {
                    List<Veza> list = new List<Veza>(veze);
                    list.RemoveAt(i);
                    int m = 0;
                    if (veza.x == x)
                    {
                        m = Konekcija(list.ToArray(), y, veza.y);
                    }
                    else if (veza.y == x)
                    {
                        m = Konekcija(list.ToArray(), y, veza.x);
                    }
                    else if (veza.x == y)
                    {
                        m = Konekcija(list.ToArray(), x, veza.y);
                    }
                    else if (veza.y == y)
                    {
                        m = Konekcija(list.ToArray(), x, veza.x);
                    }
                    if (m != -1) mogucnosti.Add(m);
                }
            }
            return mogucnosti.Count != 0 ? mogucnosti.Min() + 1 : -1;
        }

        static void Main(string[] args)
        {
            int n = Convert.ToInt32(Console.ReadLine());
            Veza[] veze = new Veza[n - 1];
            Veza veza = new Veza();
            string[] input;
            for (int i = 0; i < n - 1; i++)
            {
                input = Console.ReadLine().Split(' ');
                veza.x = Convert.ToInt32(input[0]) - 1;
                veza.y = Convert.ToInt32(input[1]) - 1;
                veze[i] = veza;
            }
            int[,] map = Map(n, veze);
            int[] banke = new int[n];
            input = Console.ReadLine().Split(' ');
            for (int i = 0; i < n; i++) banke[i] = Convert.ToInt32(input[i]);
            int q = Convert.ToInt32(Console.ReadLine());
            int[] rezultati = new int[q + 1];
            int sum, min, min_index = -1;
            for (int i = 0; i < q + 1; i++)
            {
                if (i > 0)
                {
                    input = Console.ReadLine().Split(' ');
                    banke[Convert.ToInt32(input[1]) - 1] = Convert.ToInt32(input[0]);
                }
                min = -1;
                for (int j = 0; j < n; j++)
                {
                    sum = 0;
                    for (int z = 0; z < n; z++)
                    {
                        sum += map[j, z] * banke[z];
                    }
                    if (min == -1 || sum < min)
                    {
                        min = sum;
                        min_index = j;
                    }
                }
                rezultati[i] = min_index + 1;
            }
            foreach (int r in rezultati) Console.WriteLine(r);
        }
    }
}